﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="AlterationList.aspx.cs" Inherits="GUI.Pages.AlterationList" %>

<%@ Register TagPrefix="uc" TagName="ProjectNavTest" Src="~/Controls/ProjectNavTest.ascx" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">

    <uc:ProjectNavTest ID="ProjectNavTest" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
      <asp:HiddenField ID="hdnDeletePitanje" runat="server"/>
        <asp:HiddenField ID="hdnDeleteIndeks" runat="server"/>
    <div class="row">
        <div class="col-md-12 col-sm-12">
        <div class="portlet light bordered light-blue kendo-form">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_ListAlterations %>" /> </span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-6 left">
                                   <asp:Button OnClick="btnNewClick" runat="server" ID="btnNew" CssClass="btn blue" Text="<%$ Resources:ProjectManagementUI, UI_NewAlteration %>" CausesValidation="false" />
                            </div>
                            <div class="col-md-6 right text-right">
                                <asp:Button ID="Button1" OnClick="BtnPdfClick" CssClass="btn red" Text="Export PDF"
                                    runat="server" />
                                <asp:Button ID="Button2" OnClick="BtnExcelClick" CssClass="btn red" Text="Export Excel"
                                    runat="server" />
                                <asp:Button ID="Button3" OnClick="BtnWordClick" CssClass="btn red" Text="Export Word"
                                    runat="server" />
                            </div>
                        </div>
                        <br />
                        <div class="row">
                            <div class="col-md-12">
                                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1"
                                    ClientEvents-OnRequestStart="pnlRequestStarted">
                                        <telerik:RadGrid OnGridExporting="OnGridExporting" ID="grdAlterationList" runat="server" PageSize="15" AllowFilteringByColumn="true" Skin="Bootstrap" CssClass="kendo-table"
                                            OnItemCommand="grdAlterationList_OnItemCommand" AllowPaging="true" AllowSorting="true"
                                            OnNeedDataSource="grdAlterationList_OnNeedDataSource">
                                            <GroupingSettings CaseSensitive="false" />
                                            <PagerStyle Mode="NextPrevAndNumeric" />
                                            <MasterTableView ShowHeadersWhenNoRecords="true" TableLayout="Auto" ShowFooter="False" CssClass="table table-striped table-hover"
                                                AutoGenerateColumns="False" DataKeyNames="Id">
                                                <Columns>
                                                    <telerik:GridBoundColumn UniqueName="NameColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                                                        SortExpression="Name" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>" DataField="Name" />
                                                    <telerik:GridBoundColumn UniqueName="UsersColumn" AutoPostBackOnFilter="true" CurrentFilterFunction="Contains"
                                                        SortExpression="UsersDisplayString" ShowFilterIcon="false" HeaderText="<%$ Resources:ProjectManagementUI, Task_Assigned %>"
                                                        DataField="UsersDisplayString" />
                                                    <telerik:GridBoundColumn UniqueName="InformeeColumn" AutoPostBackOnFilter="true"
                                                        CurrentFilterFunction="Contains" SortExpression="Informee" ShowFilterIcon="false"
                                                        HeaderText="<%$ Resources:ProjectManagementUI, Common_InformedBy %>" DataField="Informee" />
                                                    <telerik:GridBoundColumn UniqueName="ActivitiesColumn" AutoPostBackOnFilter="true"
                                                        CurrentFilterFunction="Contains" SortExpression="ActivitiesDisplayString" ShowFilterIcon="false"
                                                        HeaderText="<%$ Resources:ProjectManagementUI, UI_Activities %>" DataField="ActivitiesDisplayString" />
                                                     <telerik:GridTemplateColumn UniqueName="IsClosedColumn" AutoPostBackOnFilter="true"
                                                        CurrentFilterFunction="EqualTo" SortExpression="IsClosedDisplay" ShowFilterIcon="false"
                                                        HeaderText="<%$ Resources:ProjectManagementUI, Task_Finished %>" DataField="IsClosedDisplay">
                                                            <ItemTemplate>
									                                <i class="fa fa-1x fa-<%# (Eval("IsClosedDisplay").ToString() == "Yes") ? "check-square font-kendo-green" : "check-square font-kendo-red" %>"></i>  
								                            </ItemTemplate>
								                            <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                                     </telerik:GridTemplateColumn>
                                                    <telerik:GridBoundColumn UniqueName="IsClosedTekst" AutoPostBackOnFilter="true"
                                                        CurrentFilterFunction="EqualTo" SortExpression="IsClosedDisplay" ShowFilterIcon="false"
                                                        HeaderText="<%$ Resources:ProjectManagementUI, Task_Finished %>" DataField="IsClosed" Visible="false">
                                                  </telerik:GridBoundColumn>
                                                    <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderText=""
                                                        ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ButtonCssClass="btn btn-sm red" ConfirmText="<%$ Resources:ProjectManagementUI, Alteration_DeleteConfirm %>"
                                                        ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>">
                                                         <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                                    </telerik:GridButtonColumn>
                                                    <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" ButtonCssClass="btn btn-sm blue"
                                                        HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Choose %>">
                                                         <ItemStyle HorizontalAlign="Center" VerticalAlign="Middle" />
                                                    </telerik:GridButtonColumn>
                                                </Columns>
                                            </MasterTableView>
                                        </telerik:RadGrid>
                                    <telerik:RadWindowManager ID="RadWindowManager1" runat="server">
                </telerik:RadWindowManager>  
<telerik:RadScriptBlock runat="server" ID="RadScriptBlock2">
<script type="text/javascript">
              function updateRowId(arg) {
                  var rowId = document.getElementsByName("ctl00$ctl00$ctl00$MainContentPlaceHolder$Content$FormPlaceHolder$hdnDeleteIndeks");
                rowId[0].setAttribute("value", arg);
              }
             
    function updatePitanjeId(arg) {
       
        var pitanje = document.getElementsByName("ctl00$ctl00$ctl00$MainContentPlaceHolder$Content$FormPlaceHolder$hdnDeletePitanje");
        pitanje[0].setAttribute("value", arg);
                     }
             function confirmCallBackFn(arg) {
                 var pitanje = document.getElementsByName("ctl00$ctl00$ctl00$MainContentPlaceHolder$Content$FormPlaceHolder$hdnDeletePitanje");
                
                 var rowId = document.getElementsByName("ctl00$ctl00$ctl00$MainContentPlaceHolder$Content$FormPlaceHolder$hdnDeleteIndeks")[0].getAttribute("value");
                 
                 //alert(rowId);
                if (arg == true) {
                  var masterTable = $find("<%= grdAlterationList.ClientID%>").get_masterTableView();
                    pitanje[0].setAttribute("value", "Pitao");
                    masterTable.fireCommand("Delete", rowId);

                }
                else {
                    pitanje[0].setAttribute("value", "Nece");
                    
                }
             }

                                                    </script>
    </telerik:RadScriptBlock>
                                </telerik:RadAjaxPanel>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>




    <telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1">
        <div class="updatePanelProgress">
            <asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
       <script type="text/javascript">
            function pnlRequestStarted(ajaxPanel, eventArgs) {
                if (eventArgs.EventTarget.indexOf("btnPdf") > 0 ||
                eventArgs.EventTarget.indexOf("btnExcel") > 0 ||
                eventArgs.EventTarget.indexOf("btnWord") > 0) {
                    eventArgs.EnableAjax = false;
                }
            }
        </script>
</asp:Content>
